/*
 Navicat Premium Dump SQL

 Source Server         : DBngin
 Source Server Type    : MySQL
 Source Server Version : 80027 (8.0.27)
 Source Host           : localhost:3306
 Source Schema         : easy_forms

 Target Server Type    : MySQL
 Target Server Version : 80027 (8.0.27)
 File Encoding         : 65001

 Date: 10/09/2024 12:04:50
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for addon
-- ----------------------------
DROP TABLE IF EXISTS `addon`;
CREATE TABLE `addon` (
  `id` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `class` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci,
  `version` text COLLATE utf8mb4_unicode_520_ci,
  `status` tinyint(1) DEFAULT '0',
  `installed` tinyint(1) DEFAULT '0',
  `shared` int DEFAULT '0',
  `created_by` int DEFAULT NULL,
  `updated_by` int DEFAULT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of addon
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for addon_user
-- ----------------------------
DROP TABLE IF EXISTS `addon_user`;
CREATE TABLE `addon_user` (
  `addon_id` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` int NOT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  UNIQUE KEY `addon_user_addon_id_user_id` (`addon_id`,`user_id`),
  KEY `addon_user_addon_id` (`addon_id`),
  KEY `addon_user_user_id` (`user_id`),
  CONSTRAINT `fk_addon_user` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of addon_user
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for addon_user_role
-- ----------------------------
DROP TABLE IF EXISTS `addon_user_role`;
CREATE TABLE `addon_user_role` (
  `addon_id` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `role_id` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  UNIQUE KEY `addon_user_role_addon_id_role_id` (`addon_id`,`role_id`),
  KEY `addon_user_role_addon_id` (`addon_id`),
  KEY `addon_user_role_role_id` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of addon_user_role
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for auth_assignment
-- ----------------------------
DROP TABLE IF EXISTS `auth_assignment`;
CREATE TABLE `auth_assignment` (
  `item_name` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` int DEFAULT NULL,
  PRIMARY KEY (`item_name`,`user_id`),
  KEY `idx-auth_assignment-user_id` (`user_id`),
  CONSTRAINT `auth_assignment_ibfk_1` FOREIGN KEY (`item_name`) REFERENCES `auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of auth_assignment
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for auth_item
-- ----------------------------
DROP TABLE IF EXISTS `auth_item`;
CREATE TABLE `auth_item` (
  `name` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` smallint NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci,
  `rule_name` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `data` blob,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`name`),
  KEY `rule_name` (`rule_name`),
  KEY `idx-auth_item-type` (`type`),
  CONSTRAINT `auth_item_ibfk_1` FOREIGN KEY (`rule_name`) REFERENCES `auth_rule` (`name`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of auth_item
-- ----------------------------
BEGIN;
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('accessFormReports', 2, 'Access Form Reports', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('accessFormStats', 2, 'Access Form Stats', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('accessOtherFormReports', 2, 'Access Other Authors\' Form Reports', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('accessOtherFormStats', 2, 'Access Other Authors\' Form Stats', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('accessOwnFormReports', 2, 'Access Own Form Reports', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('accessOwnFormStats', 2, 'Access Own Form Stats', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('accessPerformanceTools', 2, 'Access Performance Tools', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('accessSharedFormReports', 2, 'Access Shared Form Reports', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('accessSharedFormStats', 2, 'Access Shared Form Stats', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('administrator', 1, 'Role: Administrator', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('assignUserPermissions', 2, 'Assign User Permissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('blockUsers', 2, 'Block Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeAddonsOwner', 2, 'Change Addons Owner', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeFormsOwner', 2, 'Change Forms Owner', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeOtherAddonsOwner', 2, 'Change Other Authors\' Addons Owner', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeOtherFormsOwner', 2, 'Change Other Authors\' Forms Owner', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeOtherTemplatesOwner', 2, 'Change Other Authors\' Templates Owner', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeOtherThemesOwner', 2, 'Change Other Authors\' Themes Owner', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeOwnAddonsOwner', 2, 'Change Own Addons Owner', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeOwnFormsOwner', 2, 'Change Own Forms Owner', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeOwnTemplatesOwner', 2, 'Change Own Templates Owner', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeOwnThemesOwner', 2, 'Change Own Themes Owner', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeSharedAddonsOwner', 2, 'Change Shared Addons Owner', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeSharedFormsOwner', 2, 'Change Shared Forms Owner', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeSharedTemplatesOwner', 2, 'Change Shared Templates Owner', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeSharedThemesOwner', 2, 'Change Shared Themes Owner', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeTemplatesOwner', 2, 'Change Templates Owner', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('changeThemesOwner', 2, 'Change Themes Owner', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureAddons', 2, 'Configure Addons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureForms', 2, 'Configure Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureFormsWithAddons', 2, 'Configure Forms With Add-Ons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureMailServer', 2, 'Configure Mail Server', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureOtherAddons', 2, 'Configure Other Addons', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureOtherForms', 2, 'Configure Other Authors\' Forms', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureOtherFormsWithAddons', 2, 'Configure Other Authors\' Forms With Add-Ons', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureOwnAddons', 2, 'Configure Own Addons', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureOwnForms', 2, 'Config Own Forms', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureOwnFormsWithAddons', 2, 'Config Own Forms With Addons', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureSharedAddons', 2, 'Configure Shared Addons', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureSharedForms', 2, 'Config Shared Forms', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureSharedFormsWithAddons', 2, 'Config Shared Forms With Addons', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('configureSite', 2, 'Configure Site', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('confirmUsers', 2, 'Confirm Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copyForms', 2, 'Copy Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copyOtherForms', 2, 'Copy Other Authors\' Forms', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copyOtherTemplates', 2, 'Copy Other Authors\' Templates', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copyOtherThemes', 2, 'Copy Other Authors\' Themes', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copyOwnForms', 2, 'Copy Own Forms', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copyOwnTemplates', 2, 'Copy Own Templates', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copyOwnThemes', 2, 'Copy Own Themes', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copySharedForms', 2, 'Copy Shared Forms', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copySharedTemplates', 2, 'Copy Shared Templates', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copySharedThemes', 2, 'Copy Shared Themes', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copyTemplates', 2, 'Copy Templates', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('copyThemes', 2, 'Copy Themes', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('createForms', 2, 'Create Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('createFormSubmissionComments', 2, 'Create Form Submission Comments', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('createFormSubmissions', 2, 'Create Form Submissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('createOtherFormsSubmissionsComments', 2, 'Create Other Authors\' Forms\' Submissions\' Comments', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('createOwnFormsSubmissionsComments', 2, 'Create Own Forms\' Submissions\' Comments', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('createSharedFormsSubmissionsComments', 2, 'Create Shared Forms\' Submissions\' Comments', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('createTemplates', 2, 'Create Templates', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('createThemes', 2, 'Create Themes', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('createUsers', 2, 'Create Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteForms', 2, 'Delete Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteFormSubmissionComments', 2, 'Delete Form Submission Comments', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteFormSubmissionFiles', 2, 'Delete Form Submission Files', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteFormSubmissions', 2, 'Delete Form Submissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOtherForms', 2, 'Delete Other Authors\' Forms', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOtherFormsSubmissions', 2, 'Delete Other Authors\' Forms\' Submissions', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOtherFormsSubmissionsComments', 2, 'Delete Other Authors\' Forms\' Submissions\' Comments', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOtherFormsSubmissionsFiles', 2, 'Delete Other Authors\' Forms\' Submissions\' Files', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOtherTemplates', 2, 'Delete Other Authors\' Templates', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOtherThemes', 2, 'Delete Other Authors\' Themes', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOwnForms', 2, 'Delete Own Forms', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOwnFormsSubmissions', 2, 'Delete Own Forms\' Submissions', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOwnFormsSubmissionsComments', 2, 'Delete Own Forms\' Submissions\' Comments', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOwnFormsSubmissionsFiles', 2, 'Delete Own Forms\' Submissions\' Files', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOwnTemplates', 2, 'Delete Own Templates', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteOwnThemes', 2, 'Delete Own Themes', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteSharedForms', 2, 'Delete Shared Forms', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteSharedFormsSubmissions', 2, 'Delete Shared Forms\' Submissions', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteSharedFormsSubmissionsComments', 2, 'Delete Shared Forms\' Submissions\' Comments', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteSharedFormsSubmissionsFiles', 2, 'Delete Shared Forms\' Submissions\' Files', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteSharedTemplates', 2, 'Delete Shared Templates', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteSharedThemes', 2, 'Delete Shared Themes', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteTemplates', 2, 'Delete Templates', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteThemes', 2, 'Delete Themes', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('deleteUsers', 2, 'Delete Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('exportFormSubmissions', 2, 'Export Form Submissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('exportOtherFormsSubmissions', 2, 'Export Other Authors\' Forms\' Submissions', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('exportOwnFormsSubmissions', 2, 'Export Own Forms\' Submissions', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('exportSharedFormsSubmissions', 2, 'Export Shared Forms\' Submissions', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('forcePasswordChange', 2, 'Force Password Change', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('impersonateUsers', 2, 'Impersonate Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('installAddons', 2, 'Install Addons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('installOtherAddons', 2, 'Install Other Authors\' Addons', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('installOwnAddons', 2, 'Install Own Addons', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('installSharedAddons', 2, 'Install Shared Addons', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageAddons', 2, 'Manage Addons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageForms', 2, 'Manage Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageFormSubmissions', 2, 'Manage Submissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageOtherAddons', 2, 'Manage Other Authors\' Addons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageOtherForms', 2, 'Manage Other Authors\' Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageOtherFormsSubmissions', 2, 'Manage Other Authors\' Forms\' Submissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageOtherTemplates', 2, 'Manage Other Authors\' Templates', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageOtherThemes', 2, 'Manage Other Authors\' Themes', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageOwnAddons', 2, 'Manage Own Addons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageOwnForms', 2, 'Manage Own Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageOwnFormsSubmissions', 2, 'Manage Own Forms\' Submissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageOwnTemplates', 2, 'Manage Own Templates', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageOwnThemes', 2, 'Manage Own Themes', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('managePermissions', 2, 'Manage Permissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageRoles', 2, 'Manage Roles', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageRules', 2, 'Manage Rules', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageSharedAddons', 2, 'Manage Shared Addons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageSharedForms', 2, 'Manage Shared Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageSharedFormsSubmissions', 2, 'Manage Shared Forms\' Submissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageSharedTemplates', 2, 'Manage Shared Templates', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageSharedThemes', 2, 'Manage Shared Themes', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageSite', 2, 'Manage Site', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageTemplateCategories', 2, 'Manage Template Categories', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageTemplates', 2, 'Manage Templates', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageThemes', 2, 'Manage Themes', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('manageUsers', 2, 'Manage Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('migrateData', 2, 'Migrate Data (Import / Export Forms)', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('performUpdates', 2, 'Perform Application Updates', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('publishForms', 2, 'Publish Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('publishOtherForms', 2, 'Publish Other Authors\' Forms', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('publishOwnForms', 2, 'Publish Own Forms', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('publishSharedForms', 2, 'Publish Shared Forms', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('refreshAddons', 2, 'Refresh Addons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('refreshOtherAddons', 2, 'Refresh Other Authors\' Addons', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('refreshOwnAddons', 2, 'Refresh Own Addons', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('refreshSharedAddons', 2, 'Refresh Shared Addons', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('resetFormStats', 2, 'Reset Form Stats', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('resetOtherFormStats', 2, 'Reset Other Authors\' Form Stats', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('resetOwnFormStats', 2, 'Reset Own Form Stats', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('resetSharedFormStats', 2, 'Reset Shared Form Stats', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('resetUserPasswords', 2, 'Reset User Password', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('selectUsers', 2, 'Select Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareAddons', 2, 'Share Addons with Other Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareForms', 2, 'Share Forms with Other Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareOtherAddons', 2, 'Share Other Authors\' Addons', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareOtherForms', 2, 'Share Other Forms with Other Users', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareOtherTemplates', 2, 'Share Other Authors\' Templates', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareOtherThemes', 2, 'Share Other Authors\' Themes', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareOwnAddons', 2, 'Share Own Addons', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareOwnForms', 2, 'Share Own Forms with Other Users', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareOwnTemplates', 2, 'Share Own Templates', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareOwnThemes', 2, 'Share Own Themes', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareSharedAddons', 2, 'Share Shared Addons', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareSharedForms', 2, 'Share Shared Forms with Other Users', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareSharedTemplates', 2, 'Share Shared Templates', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareSharedThemes', 2, 'Share Shared Themes', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareTemplates', 2, 'Share Templates with Other Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('shareThemes', 2, 'Share Themes with Other Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('uninstallAddons', 2, 'Uninstall Addons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('uninstallOtherAddons', 2, 'Uninstall Other Authors\' Addons', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('uninstallOwnAddons', 2, 'Uninstall Own Addons', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('uninstallSharedAddons', 2, 'Uninstall Shared Addons', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateAddons', 2, 'Update Addons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateForms', 2, 'Update Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateFormSubmissions', 2, 'Update Form Submissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateOtherAddons', 2, 'Update Other Authors\' Addons', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateOtherForms', 2, 'Update Other Authors\' Forms', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateOtherFormsSubmissions', 2, 'Update Other Authors\' Forms\' Submissions', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateOtherTemplates', 2, 'Update Other Authors\' Templates', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateOtherThemes', 2, 'Update Other Authors\' Themes', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateOwnAddons', 2, 'Update Own Addons', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateOwnForms', 2, 'Update Own Forms', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateOwnFormsSubmissions', 2, 'Update Own Forms\' Submissions', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateOwnTemplates', 2, 'Update Own Templates', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateOwnThemes', 2, 'Update Own Themes', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateSharedAddons', 2, 'Update Shared Addons', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateSharedForms', 2, 'Update Shared Forms', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateSharedFormsSubmissions', 2, 'Update Shared Forms\' Submissions', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateSharedTemplates', 2, 'Update Shared Templates', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateSharedThemes', 2, 'Update Shared Themes', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateTemplates', 2, 'Update Templates', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateThemes', 2, 'Update Themes', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('updateUsers', 2, 'Update Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('user', 1, 'Role: User', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewAddons', 2, 'View Addons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewBulkActionsInAddons', 2, 'View Bulk Actions In Addons', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewBulkActionsInForms', 2, 'View Bulk Actions In Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewBulkActionsInFormSubmissions', 2, 'View Bulk Actions In Form Submissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewBulkActionsInTemplates', 2, 'View Bulk Actions In Templates', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewBulkActionsInThemes', 2, 'View Bulk Actions In Themes', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewBulkActionsInUsers', 2, 'View Bulk Actions In Users', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewForms', 2, 'View Forms', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewFormSubmissionComments', 2, 'View Form Submission Comments', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewFormSubmissionFiles', 2, 'View Form Submission Files', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewFormSubmissions', 2, 'View Form Submissions', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOtherAddons', 2, 'View Other Authors\' Addons', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOtherForms', 2, 'View Other Authors\' Forms', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOtherFormsSubmissions', 2, 'View Other Authors\' Forms\' Submissions', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOtherFormsSubmissionsComments', 2, 'View Other Authors\' Forms\' Submissions\' Comments', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOtherFormsSubmissionsFiles', 2, 'View Other Authors\' Forms\' Submissions\' Files', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOtherTemplates', 2, 'View Other Authors\' Templates', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOtherThemes', 2, 'View Other Authors\' Themes', 'isNotAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOwnAddons', 2, 'View Own Addons', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOwnForms', 2, 'View Own Forms', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOwnFormsSubmissions', 2, 'View Own Forms\' Submissions', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOwnFormsSubmissionsComments', 2, 'View Own Forms\' Submissions\' Comments', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOwnFormsSubmissionsFiles', 2, 'View Own Forms\' Submissions\' Files', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOwnTemplates', 2, 'View Own Templates', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewOwnThemes', 2, 'View Own Themes', 'isAuthor', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewSharedAddons', 2, 'View Shared Addons', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewSharedForms', 2, 'View Shared Forms', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewSharedFormsSubmissions', 2, 'View Shared Forms\' Submissions', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewSharedFormsSubmissionsComments', 2, 'View Shared Forms\' Submissions\' Comments', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewSharedFormsSubmissionsFiles', 2, 'View Shared Forms\' Submissions\' Files', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewSharedTemplates', 2, 'View Shared Templates', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewSharedThemes', 2, 'View Shared Themes', 'isShared', NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewTemplates', 2, 'View Templates', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewThemes', 2, 'View Themes', NULL, NULL, 1725987826, 1725987826);
INSERT INTO `auth_item` (`name`, `type`, `description`, `rule_name`, `data`, `created_at`, `updated_at`) VALUES ('viewUsers', 2, 'View Users', NULL, NULL, 1725987826, 1725987826);
COMMIT;

-- ----------------------------
-- Table structure for auth_item_child
-- ----------------------------
DROP TABLE IF EXISTS `auth_item_child`;
CREATE TABLE `auth_item_child` (
  `parent` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `child` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`parent`,`child`),
  KEY `child` (`child`),
  CONSTRAINT `auth_item_child_ibfk_1` FOREIGN KEY (`parent`) REFERENCES `auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `auth_item_child_ibfk_2` FOREIGN KEY (`child`) REFERENCES `auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of auth_item_child
-- ----------------------------
BEGIN;
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('accessOtherFormReports', 'accessFormReports');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('accessOwnFormReports', 'accessFormReports');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('accessSharedFormReports', 'accessFormReports');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'accessFormReports');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('accessOtherFormStats', 'accessFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('accessOwnFormStats', 'accessFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('accessSharedFormStats', 'accessFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'accessFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'accessOtherFormReports');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'accessOtherFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'accessOwnFormReports');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'accessOwnFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSite', 'accessPerformanceTools');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'accessSharedFormReports');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'accessSharedFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'assignUserPermissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'blockUsers');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeOtherAddonsOwner', 'changeAddonsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeOwnAddonsOwner', 'changeAddonsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeSharedAddonsOwner', 'changeAddonsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'changeAddonsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeOtherFormsOwner', 'changeFormsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeOwnFormsOwner', 'changeFormsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeSharedFormsOwner', 'changeFormsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'changeFormsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherAddons', 'changeOtherAddonsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'changeOtherFormsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherTemplates', 'changeOtherTemplatesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherThemes', 'changeOtherThemesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnAddons', 'changeOwnAddonsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'changeOwnFormsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnTemplates', 'changeOwnTemplatesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnThemes', 'changeOwnThemesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedAddons', 'changeSharedAddonsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'changeSharedFormsOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedTemplates', 'changeSharedTemplatesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedThemes', 'changeSharedThemesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeOtherTemplatesOwner', 'changeTemplatesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeOwnTemplatesOwner', 'changeTemplatesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeSharedTemplatesOwner', 'changeTemplatesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'changeTemplatesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeOtherThemesOwner', 'changeThemesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeOwnThemesOwner', 'changeThemesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('changeSharedThemesOwner', 'changeThemesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageThemes', 'changeThemesOwner');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('configureOtherAddons', 'configureAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('configureOwnAddons', 'configureAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('configureSharedAddons', 'configureAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'configureAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('configureOtherForms', 'configureForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('configureOwnForms', 'configureForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('configureSharedForms', 'configureForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'configureForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('configureOtherFormsWithAddons', 'configureFormsWithAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('configureOwnFormsWithAddons', 'configureFormsWithAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('configureSharedFormsWithAddons', 'configureFormsWithAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'configureFormsWithAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSite', 'configureMailServer');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherAddons', 'configureOtherAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'configureOtherForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'configureOtherFormsWithAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnAddons', 'configureOwnAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'configureOwnForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'configureOwnFormsWithAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedAddons', 'configureSharedAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'configureSharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'configureSharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'configureSharedFormsWithAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'configureSharedFormsWithAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSite', 'configureSite');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'confirmUsers');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('copyOtherForms', 'copyForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('copyOwnForms', 'copyForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('copySharedForms', 'copyForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'copyForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'copyOtherForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherTemplates', 'copyOtherTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherThemes', 'copyOtherThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'copyOwnForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnTemplates', 'copyOwnTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnThemes', 'copyOwnThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'copySharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedTemplates', 'copySharedTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedThemes', 'copySharedThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('copyOtherTemplates', 'copyTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('copyOwnTemplates', 'copyTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('copySharedTemplates', 'copyTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'copyTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('copyOtherThemes', 'copyThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('copyOwnThemes', 'copyThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('copySharedThemes', 'copyThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageThemes', 'copyThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'createForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'createForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('createOtherFormsSubmissionsComments', 'createFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('createOwnFormsSubmissionsComments', 'createFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('createSharedFormsSubmissionsComments', 'createFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'createFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'createFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnFormsSubmissions', 'createFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherFormsSubmissions', 'createOtherFormsSubmissionsComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnFormsSubmissions', 'createOwnFormsSubmissionsComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedFormsSubmissions', 'createSharedFormsSubmissionsComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnTemplates', 'createTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'createTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnThemes', 'createThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageThemes', 'createThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'createUsers');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOtherForms', 'deleteForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOwnForms', 'deleteForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteSharedForms', 'deleteForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'deleteForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOtherFormsSubmissionsComments', 'deleteFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOwnFormsSubmissionsComments', 'deleteFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteSharedFormsSubmissionsComments', 'deleteFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'deleteFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOtherFormsSubmissionsFiles', 'deleteFormSubmissionFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOwnFormsSubmissionsFiles', 'deleteFormSubmissionFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteSharedFormsSubmissionsFiles', 'deleteFormSubmissionFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'deleteFormSubmissionFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOtherFormsSubmissions', 'deleteFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOwnFormsSubmissions', 'deleteFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteSharedFormsSubmissions', 'deleteFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'deleteFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'deleteOtherForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherFormsSubmissions', 'deleteOtherFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherFormsSubmissions', 'deleteOtherFormsSubmissionsComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherFormsSubmissions', 'deleteOtherFormsSubmissionsFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherTemplates', 'deleteOtherTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherThemes', 'deleteOtherThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'deleteOwnForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnFormsSubmissions', 'deleteOwnFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnFormsSubmissions', 'deleteOwnFormsSubmissionsComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnFormsSubmissions', 'deleteOwnFormsSubmissionsFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnTemplates', 'deleteOwnTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnThemes', 'deleteOwnThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'deleteSharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedFormsSubmissions', 'deleteSharedFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedFormsSubmissions', 'deleteSharedFormsSubmissionsComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedFormsSubmissions', 'deleteSharedFormsSubmissionsFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedTemplates', 'deleteSharedTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedThemes', 'deleteSharedThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOtherTemplates', 'deleteTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOwnTemplates', 'deleteTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteSharedTemplates', 'deleteTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'deleteTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOtherThemes', 'deleteThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteOwnThemes', 'deleteThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('deleteSharedThemes', 'deleteThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageThemes', 'deleteThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'deleteUsers');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('exportOtherFormsSubmissions', 'exportFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('exportOwnFormsSubmissions', 'exportFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('exportSharedFormsSubmissions', 'exportFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'exportFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherFormsSubmissions', 'exportOtherFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnFormsSubmissions', 'exportOwnFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedFormsSubmissions', 'exportSharedFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'forcePasswordChange');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'impersonateUsers');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('installOtherAddons', 'installAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('installOwnAddons', 'installAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('installSharedAddons', 'installAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'installAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherAddons', 'installOtherAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnAddons', 'installOwnAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedAddons', 'installSharedAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('administrator', 'manageAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('administrator', 'manageForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('administrator', 'manageFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'manageOtherAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'manageOtherForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'manageOtherFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'manageOtherTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageThemes', 'manageOtherThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'manageOwnAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'manageOwnForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'manageOwnForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'manageOwnFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'manageOwnFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'manageOwnTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'manageOwnTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageThemes', 'manageOwnThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'manageOwnThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'managePermissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'manageRoles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'manageRules');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'manageSharedAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'manageSharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'manageSharedFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'manageSharedFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'manageSharedTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageThemes', 'manageSharedThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('administrator', 'manageSite');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'manageTemplateCategories');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('administrator', 'manageTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('administrator', 'manageThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('administrator', 'manageUsers');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSite', 'migrateData');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSite', 'performUpdates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'publishForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('publishOtherForms', 'publishForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('publishOwnForms', 'publishForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('publishSharedForms', 'publishForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'publishOtherForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'publishOwnForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'publishSharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'publishSharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'refreshAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('refreshOtherAddons', 'refreshAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('refreshOwnAddons', 'refreshAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('refreshSharedAddons', 'refreshAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherAddons', 'refreshOtherAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnAddons', 'refreshOwnAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedAddons', 'refreshSharedAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'resetFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('resetOtherFormStats', 'resetFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('resetOwnFormStats', 'resetFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('resetSharedFormStats', 'resetFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'resetOtherFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'resetOwnFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'resetSharedFormStats');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'resetUserPasswords');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'selectUsers');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'shareAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareOtherAddons', 'shareAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareOwnAddons', 'shareAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareSharedAddons', 'shareAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'shareForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareOtherForms', 'shareForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareOwnForms', 'shareForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareSharedForms', 'shareForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherAddons', 'shareOtherAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'shareOtherForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherTemplates', 'shareOtherTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherThemes', 'shareOtherThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnAddons', 'shareOwnAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'shareOwnForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnTemplates', 'shareOwnTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnThemes', 'shareOwnThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedAddons', 'shareSharedAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'shareSharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedTemplates', 'shareSharedTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedThemes', 'shareSharedThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'shareTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareOtherTemplates', 'shareTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareOwnTemplates', 'shareTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareSharedTemplates', 'shareTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageThemes', 'shareThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareOtherThemes', 'shareThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareOwnThemes', 'shareThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('shareSharedThemes', 'shareThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'uninstallAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('uninstallOtherAddons', 'uninstallAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('uninstallOwnAddons', 'uninstallAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('uninstallSharedAddons', 'uninstallAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherAddons', 'uninstallOtherAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnAddons', 'uninstallOwnAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedAddons', 'uninstallSharedAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'updateAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateOtherAddons', 'updateAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateOwnAddons', 'updateAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateSharedAddons', 'updateAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'updateForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateOtherForms', 'updateForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateOwnForms', 'updateForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateSharedForms', 'updateForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'updateFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateOtherFormsSubmissions', 'updateFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateOwnFormsSubmissions', 'updateFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateSharedFormsSubmissions', 'updateFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherAddons', 'updateOtherAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'updateOtherForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherFormsSubmissions', 'updateOtherFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherTemplates', 'updateOtherTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherThemes', 'updateOtherThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnAddons', 'updateOwnAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'updateOwnForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnFormsSubmissions', 'updateOwnFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnTemplates', 'updateOwnTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnThemes', 'updateOwnThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedAddons', 'updateSharedAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'updateSharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'updateSharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedFormsSubmissions', 'updateSharedFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedTemplates', 'updateSharedTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedThemes', 'updateSharedThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'updateTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateOtherTemplates', 'updateTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateOwnTemplates', 'updateTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateSharedTemplates', 'updateTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageThemes', 'updateThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateOtherThemes', 'updateThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateOwnThemes', 'updateThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('updateSharedThemes', 'updateThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'updateUsers');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'viewAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOtherAddons', 'viewAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOwnAddons', 'viewAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewSharedAddons', 'viewAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageAddons', 'viewBulkActionsInAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'viewBulkActionsInForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'viewBulkActionsInFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'viewBulkActionsInTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageThemes', 'viewBulkActionsInThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'viewBulkActionsInUsers');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageForms', 'viewForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOtherForms', 'viewForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOwnForms', 'viewForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewSharedForms', 'viewForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'viewFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOtherFormsSubmissionsComments', 'viewFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOwnFormsSubmissionsComments', 'viewFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewSharedFormsSubmissionsComments', 'viewFormSubmissionComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'viewFormSubmissionFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOtherFormsSubmissionsFiles', 'viewFormSubmissionFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOwnFormsSubmissionsFiles', 'viewFormSubmissionFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewSharedFormsSubmissionsFiles', 'viewFormSubmissionFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageFormSubmissions', 'viewFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOtherFormsSubmissions', 'viewFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOwnFormsSubmissions', 'viewFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewSharedFormsSubmissions', 'viewFormSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherAddons', 'viewOtherAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherForms', 'viewOtherForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherFormsSubmissions', 'viewOtherFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherFormsSubmissions', 'viewOtherFormsSubmissionsComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherFormsSubmissions', 'viewOtherFormsSubmissionsFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherTemplates', 'viewOtherTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOtherThemes', 'viewOtherThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnAddons', 'viewOwnAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnForms', 'viewOwnForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnFormsSubmissions', 'viewOwnFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnFormsSubmissions', 'viewOwnFormsSubmissionsComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnFormsSubmissions', 'viewOwnFormsSubmissionsFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnTemplates', 'viewOwnTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageOwnThemes', 'viewOwnThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedAddons', 'viewSharedAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'viewSharedAddons');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedForms', 'viewSharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'viewSharedForms');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedFormsSubmissions', 'viewSharedFormsSubmissions');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedFormsSubmissions', 'viewSharedFormsSubmissionsComments');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedFormsSubmissions', 'viewSharedFormsSubmissionsFiles');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedTemplates', 'viewSharedTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'viewSharedTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageSharedThemes', 'viewSharedThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('user', 'viewSharedThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageTemplates', 'viewTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOtherTemplates', 'viewTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOwnTemplates', 'viewTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewSharedTemplates', 'viewTemplates');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageThemes', 'viewThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOtherThemes', 'viewThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewOwnThemes', 'viewThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('viewSharedThemes', 'viewThemes');
INSERT INTO `auth_item_child` (`parent`, `child`) VALUES ('manageUsers', 'viewUsers');
COMMIT;

-- ----------------------------
-- Table structure for auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `auth_rule`;
CREATE TABLE `auth_rule` (
  `name` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` blob,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of auth_rule
-- ----------------------------
BEGIN;
INSERT INTO `auth_rule` (`name`, `data`, `created_at`, `updated_at`) VALUES ('isAuthor', 0x4F3A33363A226170705C636F6D706F6E656E74735C726261635C72756C65735C417574686F7252756C65223A333A7B733A343A226E616D65223B733A383A226973417574686F72223B733A393A22637265617465644174223B693A313732353938373832363B733A393A22757064617465644174223B693A313732353938373832363B7D, 1725987826, 1725987826);
INSERT INTO `auth_rule` (`name`, `data`, `created_at`, `updated_at`) VALUES ('isNotAuthor', 0x4F3A33393A226170705C636F6D706F6E656E74735C726261635C72756C65735C4E6F74417574686F7252756C65223A333A7B733A343A226E616D65223B733A31313A2269734E6F74417574686F72223B733A393A22637265617465644174223B693A313732353938373832363B733A393A22757064617465644174223B693A313732353938373832363B7D, 1725987826, 1725987826);
INSERT INTO `auth_rule` (`name`, `data`, `created_at`, `updated_at`) VALUES ('isShared', 0x4F3A33363A226170705C636F6D706F6E656E74735C726261635C72756C65735C53686172656452756C65223A333A7B733A343A226E616D65223B733A383A226973536861726564223B733A393A22637265617465644174223B693A313732353938373832363B733A393A22757064617465644174223B693A313732353938373832363B7D, 1725987826, 1725987826);
COMMIT;

-- ----------------------------
-- Table structure for event
-- ----------------------------
DROP TABLE IF EXISTS `event`;
CREATE TABLE `event` (
  `app_id` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `platform` text COLLATE utf8mb4_unicode_520_ci,
  `etl_tstamp` int DEFAULT NULL,
  `collector_tstamp` int NOT NULL,
  `dvce_tstamp` bigint DEFAULT NULL,
  `event` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_id` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `txn_id` int DEFAULT NULL,
  `name_tracker` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `v_tracker` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `v_collector` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `v_etl` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` text COLLATE utf8mb4_unicode_520_ci,
  `user_ipaddress` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_fingerprint` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `domain_userid` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `domain_sessionidx` smallint DEFAULT NULL,
  `network_userid` varchar(38) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `geo_country` text COLLATE utf8mb4_unicode_520_ci,
  `geo_region` varchar(3) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `geo_city` varchar(75) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `geo_zipcode` varchar(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `geo_latitude` double DEFAULT NULL,
  `geo_longitude` double DEFAULT NULL,
  `geo_region_name` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `page_url` text COLLATE utf8mb4_unicode_520_ci,
  `page_title` text COLLATE utf8mb4_unicode_520_ci,
  `page_referrer` text COLLATE utf8mb4_unicode_520_ci,
  `page_urlscheme` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `page_urlhost` text COLLATE utf8mb4_unicode_520_ci,
  `page_urlport` int DEFAULT NULL,
  `page_urlpath` text COLLATE utf8mb4_unicode_520_ci,
  `page_urlquery` text COLLATE utf8mb4_unicode_520_ci,
  `page_urlfragment` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `refr_urlscheme` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `refr_urlhost` text COLLATE utf8mb4_unicode_520_ci,
  `refr_urlport` int DEFAULT NULL,
  `refr_urlpath` text COLLATE utf8mb4_unicode_520_ci,
  `refr_urlquery` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `refr_urlfragment` text COLLATE utf8mb4_unicode_520_ci,
  `refr_medium` varchar(25) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `refr_source` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `refr_term` text COLLATE utf8mb4_unicode_520_ci,
  `mkt_medium` text COLLATE utf8mb4_unicode_520_ci,
  `mkt_source` text COLLATE utf8mb4_unicode_520_ci,
  `mkt_term` text COLLATE utf8mb4_unicode_520_ci,
  `mkt_content` text COLLATE utf8mb4_unicode_520_ci,
  `mkt_campaign` text COLLATE utf8mb4_unicode_520_ci,
  `contexts` text COLLATE utf8mb4_unicode_520_ci,
  `se_category` text COLLATE utf8mb4_unicode_520_ci,
  `se_action` text COLLATE utf8mb4_unicode_520_ci,
  `se_label` text COLLATE utf8mb4_unicode_520_ci,
  `se_property` text COLLATE utf8mb4_unicode_520_ci,
  `se_value` double DEFAULT NULL,
  `unstruct_event` text COLLATE utf8mb4_unicode_520_ci,
  `tr_orderid` text COLLATE utf8mb4_unicode_520_ci,
  `tr_affiliation` text COLLATE utf8mb4_unicode_520_ci,
  `tr_total` decimal(18,2) DEFAULT NULL,
  `tr_tax` decimal(18,2) DEFAULT NULL,
  `tr_shipping` decimal(18,2) DEFAULT NULL,
  `tr_city` text COLLATE utf8mb4_unicode_520_ci,
  `tr_state` text COLLATE utf8mb4_unicode_520_ci,
  `tr_country` text COLLATE utf8mb4_unicode_520_ci,
  `ti_orderid` text COLLATE utf8mb4_unicode_520_ci,
  `ti_sku` text COLLATE utf8mb4_unicode_520_ci,
  `ti_name` text COLLATE utf8mb4_unicode_520_ci,
  `ti_category` text COLLATE utf8mb4_unicode_520_ci,
  `ti_price` decimal(18,2) DEFAULT NULL,
  `ti_quantity` int DEFAULT NULL,
  `pp_xoffset_min` int DEFAULT NULL,
  `pp_xoffset_max` int DEFAULT NULL,
  `pp_yoffset_min` int DEFAULT NULL,
  `pp_yoffset_max` int DEFAULT NULL,
  `useragent` text COLLATE utf8mb4_unicode_520_ci,
  `br_name` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `br_family` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `br_version` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `br_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `br_renderengine` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `br_lang` text COLLATE utf8mb4_unicode_520_ci,
  `br_features_pdf` tinyint(1) DEFAULT NULL,
  `br_features_flash` tinyint(1) DEFAULT NULL,
  `br_features_java` tinyint(1) DEFAULT NULL,
  `br_features_director` tinyint(1) DEFAULT NULL,
  `br_features_quicktime` tinyint(1) DEFAULT NULL,
  `br_features_realplayer` tinyint(1) DEFAULT NULL,
  `br_features_windowsmedia` tinyint(1) DEFAULT NULL,
  `br_features_gears` tinyint(1) DEFAULT NULL,
  `br_features_silverlight` tinyint(1) DEFAULT NULL,
  `br_cookies` tinyint(1) DEFAULT NULL,
  `br_colordepth` text COLLATE utf8mb4_unicode_520_ci,
  `br_viewwidth` int DEFAULT NULL,
  `br_viewheight` int DEFAULT NULL,
  `os_name` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `os_family` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `os_manufacturer` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `os_timezone` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `dvce_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `dvce_ismobile` tinyint(1) DEFAULT NULL,
  `dvce_screenwidth` int DEFAULT NULL,
  `dvce_screenheight` int DEFAULT NULL,
  `doc_charset` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `doc_width` int DEFAULT NULL,
  `doc_height` int DEFAULT NULL,
  `geo_timezone` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `mkt_clickid` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `mkt_network` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `etl_tags` text COLLATE utf8mb4_unicode_520_ci,
  `dvce_sent_tstamp` bigint DEFAULT NULL,
  `domain_sessionid` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of event
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for folder
-- ----------------------------
DROP TABLE IF EXISTS `folder`;
CREATE TABLE `folder` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_by` int DEFAULT NULL,
  `updated_by` int DEFAULT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of folder
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form
-- ----------------------------
DROP TABLE IF EXISTS `form`;
CREATE TABLE `form` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` text COLLATE utf8mb4_unicode_520_ci,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `is_private` tinyint(1) DEFAULT '0',
  `use_password` tinyint(1) NOT NULL DEFAULT '0',
  `password` text COLLATE utf8mb4_unicode_520_ci,
  `authorized_urls` tinyint(1) NOT NULL DEFAULT '0',
  `urls` text COLLATE utf8mb4_unicode_520_ci,
  `authorized_urls_error_type` tinyint DEFAULT NULL,
  `authorized_urls_error_message` text COLLATE utf8mb4_unicode_520_ci,
  `schedule` tinyint(1) NOT NULL DEFAULT '0',
  `schedule_start_date` int DEFAULT NULL,
  `schedule_end_date` int DEFAULT NULL,
  `total_limit` tinyint(1) NOT NULL DEFAULT '0',
  `total_limit_number` int DEFAULT NULL,
  `total_limit_time_unit` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `total_limit_action` tinyint(1) DEFAULT '0',
  `user_limit` tinyint(1) NOT NULL DEFAULT '0',
  `user_limit_type` tinyint(1) DEFAULT NULL,
  `submission_scope` tinyint(1) DEFAULT '0',
  `user_limit_number` int DEFAULT NULL,
  `user_limit_time_unit` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `submission_number` int DEFAULT '1',
  `submission_number_prefix` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `submission_number_suffix` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `submission_number_width` int DEFAULT NULL,
  `submission_editable` tinyint(1) DEFAULT '0',
  `submission_editable_time_length` int DEFAULT NULL,
  `submission_editable_time_unit` varchar(1) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `submission_timezone` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `submission_dateformat` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `submission_editable_conditions` text COLLATE utf8mb4_unicode_520_ci,
  `save` tinyint(1) NOT NULL DEFAULT '1',
  `resume` tinyint(1) NOT NULL DEFAULT '0',
  `autocomplete` tinyint(1) NOT NULL DEFAULT '1',
  `novalidate` tinyint(1) NOT NULL DEFAULT '0',
  `analytics` tinyint(1) NOT NULL DEFAULT '1',
  `honeypot` tinyint(1) NOT NULL DEFAULT '1',
  `recaptcha` tinyint(1) NOT NULL DEFAULT '0',
  `protected_files` tinyint(1) DEFAULT '0',
  `ip_tracking` tinyint(1) DEFAULT '1',
  `browser_fingerprint` tinyint(1) DEFAULT '1',
  `shared` int DEFAULT '0',
  `language` varchar(5) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'en-US',
  `text_direction` varchar(3) COLLATE utf8mb4_unicode_520_ci DEFAULT 'ltr',
  `message` text COLLATE utf8mb4_unicode_520_ci,
  `preferences` text COLLATE utf8mb4_unicode_520_ci,
  `created_by` int NOT NULL,
  `updated_by` int NOT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_chart
-- ----------------------------
DROP TABLE IF EXISTS `form_chart`;
CREATE TABLE `form_chart` (
  `form_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `width` int DEFAULT NULL,
  `height` int DEFAULT NULL,
  `gsX` int DEFAULT NULL,
  `gsY` int DEFAULT NULL,
  `gsW` int DEFAULT NULL,
  `gsH` int DEFAULT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  UNIQUE KEY `form_chart_form_id_name` (`form_id`,`name`),
  KEY `form_chart_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_chart
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_confirmation
-- ----------------------------
DROP TABLE IF EXISTS `form_confirmation`;
CREATE TABLE `form_confirmation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `form_id` int NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `message` text COLLATE utf8mb4_unicode_520_ci,
  `url` text COLLATE utf8mb4_unicode_520_ci,
  `append` int NOT NULL DEFAULT '0',
  `alias` int NOT NULL DEFAULT '0',
  `seconds` int DEFAULT NULL,
  `hide_form` tinyint DEFAULT NULL,
  `custom_html` tinyint DEFAULT NULL,
  `send_email` tinyint(1) NOT NULL DEFAULT '0',
  `mail_to` text COLLATE utf8mb4_unicode_520_ci,
  `mail_from` text COLLATE utf8mb4_unicode_520_ci,
  `mail_cc` text COLLATE utf8mb4_unicode_520_ci,
  `mail_bcc` text COLLATE utf8mb4_unicode_520_ci,
  `mail_subject` text COLLATE utf8mb4_unicode_520_ci,
  `mail_message` text COLLATE utf8mb4_unicode_520_ci,
  `mail_from_name` text COLLATE utf8mb4_unicode_520_ci,
  `mail_receipt_copy` tinyint(1) DEFAULT '0',
  `mail_attach` int NOT NULL DEFAULT '1',
  `mail_attachments` text COLLATE utf8mb4_unicode_520_ci,
  `opt_in` int DEFAULT NULL,
  `opt_in_type` int DEFAULT '0',
  `opt_in_message` text COLLATE utf8mb4_unicode_520_ci,
  `opt_in_url` text COLLATE utf8mb4_unicode_520_ci,
  `opt_out` int DEFAULT NULL,
  `opt_out_type` int DEFAULT '0',
  `opt_out_message` text COLLATE utf8mb4_unicode_520_ci,
  `opt_out_url` text COLLATE utf8mb4_unicode_520_ci,
  `opt_custom_html` tinyint DEFAULT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_confirmation_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_confirmation
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_confirmation_rule
-- ----------------------------
DROP TABLE IF EXISTS `form_confirmation_rule`;
CREATE TABLE `form_confirmation_rule` (
  `id` int NOT NULL AUTO_INCREMENT,
  `form_id` int NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `conditions` text COLLATE utf8mb4_unicode_520_ci,
  `action` int NOT NULL DEFAULT '0',
  `message` text COLLATE utf8mb4_unicode_520_ci,
  `url` text COLLATE utf8mb4_unicode_520_ci,
  `append` int NOT NULL DEFAULT '0',
  `alias` int NOT NULL DEFAULT '0',
  `seconds` int DEFAULT NULL,
  `custom_html` tinyint DEFAULT NULL,
  `created_by` int DEFAULT NULL,
  `updated_by` int DEFAULT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_confirmation_rule
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_data
-- ----------------------------
DROP TABLE IF EXISTS `form_data`;
CREATE TABLE `form_data` (
  `id` int NOT NULL AUTO_INCREMENT,
  `form_id` int NOT NULL,
  `builder` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `fields` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `html` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `height` int NOT NULL,
  `version` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_data_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_data
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_email
-- ----------------------------
DROP TABLE IF EXISTS `form_email`;
CREATE TABLE `form_email` (
  `id` int NOT NULL AUTO_INCREMENT,
  `form_id` int NOT NULL,
  `field_to` text COLLATE utf8mb4_unicode_520_ci,
  `to` text COLLATE utf8mb4_unicode_520_ci,
  `from` text COLLATE utf8mb4_unicode_520_ci,
  `from_name` text COLLATE utf8mb4_unicode_520_ci,
  `cc` text COLLATE utf8mb4_unicode_520_ci,
  `bcc` text COLLATE utf8mb4_unicode_520_ci,
  `subject` text COLLATE utf8mb4_unicode_520_ci,
  `type` int NOT NULL DEFAULT '0',
  `message` text COLLATE utf8mb4_unicode_520_ci,
  `plain_text` tinyint(1) NOT NULL DEFAULT '0',
  `attach` tinyint(1) NOT NULL DEFAULT '1',
  `receipt_copy` int NOT NULL DEFAULT '0',
  `event` text COLLATE utf8mb4_unicode_520_ci,
  `conditions` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_email_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_email
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_folder
-- ----------------------------
DROP TABLE IF EXISTS `form_folder`;
CREATE TABLE `form_folder` (
  `form_id` int DEFAULT NULL,
  `folder_id` int DEFAULT NULL,
  `created_by` int DEFAULT NULL,
  `updated_by` int DEFAULT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  UNIQUE KEY `form_folder_form_id_folder_id` (`form_id`,`folder_id`),
  KEY `form_folder_form_id` (`form_id`),
  KEY `form_folder_folder_id` (`folder_id`),
  CONSTRAINT `fk_form_folder` FOREIGN KEY (`form_id`) REFERENCES `form` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_folder
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_rule
-- ----------------------------
DROP TABLE IF EXISTS `form_rule`;
CREATE TABLE `form_rule` (
  `id` int NOT NULL AUTO_INCREMENT,
  `form_id` int NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `opposite` tinyint(1) NOT NULL DEFAULT '1',
  `ordinal` int NOT NULL DEFAULT '0',
  `conditions` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `actions` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_rule_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_rule
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_submission
-- ----------------------------
DROP TABLE IF EXISTS `form_submission`;
CREATE TABLE `form_submission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `form_id` int NOT NULL,
  `number` text COLLATE utf8mb4_unicode_520_ci,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `new` tinyint(1) NOT NULL DEFAULT '1',
  `important` tinyint(1) NOT NULL DEFAULT '0',
  `sender` text COLLATE utf8mb4_unicode_520_ci,
  `data` text COLLATE utf8mb4_unicode_520_ci,
  `ip` tinytext COLLATE utf8mb4_unicode_520_ci,
  `browser_fingerprint` text COLLATE utf8mb4_unicode_520_ci,
  `created_by` int DEFAULT NULL,
  `updated_by` int DEFAULT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_submission_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_submission
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_submission_comment
-- ----------------------------
DROP TABLE IF EXISTS `form_submission_comment`;
CREATE TABLE `form_submission_comment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `submission_id` int NOT NULL,
  `form_id` int NOT NULL,
  `content` text COLLATE utf8mb4_unicode_520_ci,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_by` int NOT NULL,
  `updated_by` int NOT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_submission_comment_submission_id` (`submission_id`),
  KEY `form_submission_comment_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_submission_comment
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_submission_file
-- ----------------------------
DROP TABLE IF EXISTS `form_submission_file`;
CREATE TABLE `form_submission_file` (
  `id` int NOT NULL AUTO_INCREMENT,
  `submission_id` int NOT NULL,
  `form_id` int NOT NULL,
  `field` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` text COLLATE utf8mb4_unicode_520_ci,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `extension` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `size` int DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_submission_file_submission_id` (`submission_id`),
  KEY `form_submission_file_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_submission_file
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_ui
-- ----------------------------
DROP TABLE IF EXISTS `form_ui`;
CREATE TABLE `form_ui` (
  `id` int NOT NULL AUTO_INCREMENT,
  `form_id` int NOT NULL,
  `theme_id` int DEFAULT NULL,
  `js_file` text COLLATE utf8mb4_unicode_520_ci,
  `favicon` text COLLATE utf8mb4_unicode_520_ci,
  `logo` text COLLATE utf8mb4_unicode_520_ci,
  `logo_link` tinyint(1) DEFAULT '1',
  `logo_link_url` text COLLATE utf8mb4_unicode_520_ci,
  `meta_image` text COLLATE utf8mb4_unicode_520_ci,
  `meta_title` text COLLATE utf8mb4_unicode_520_ci,
  `meta_description` text COLLATE utf8mb4_unicode_520_ci,
  `styles` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_ui_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_ui
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for form_user
-- ----------------------------
DROP TABLE IF EXISTS `form_user`;
CREATE TABLE `form_user` (
  `form_id` int NOT NULL,
  `user_id` int NOT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  UNIQUE KEY `form_user_form_id_user_id` (`form_id`,`user_id`),
  KEY `form_user_form_id` (`form_id`),
  KEY `form_user_user_id` (`user_id`),
  CONSTRAINT `fk_form_user` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of form_user
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for log_event
-- ----------------------------
DROP TABLE IF EXISTS `log_event`;
CREATE TABLE `log_event` (
  `app_id` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `platform` text COLLATE utf8mb4_unicode_520_ci,
  `etl_tstamp` int DEFAULT NULL,
  `collector_tstamp` int NOT NULL,
  `dvce_tstamp` bigint DEFAULT NULL,
  `event` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_id` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `txn_id` int DEFAULT NULL,
  `name_tracker` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `v_tracker` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `v_collector` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `v_etl` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` text COLLATE utf8mb4_unicode_520_ci,
  `user_ipaddress` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_fingerprint` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `domain_userid` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `domain_sessionidx` smallint DEFAULT NULL,
  `network_userid` varchar(38) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `geo_country` text COLLATE utf8mb4_unicode_520_ci,
  `geo_region` varchar(3) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `geo_city` varchar(75) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `geo_zipcode` varchar(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `geo_latitude` double DEFAULT NULL,
  `geo_longitude` double DEFAULT NULL,
  `geo_region_name` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `page_url` text COLLATE utf8mb4_unicode_520_ci,
  `page_title` text COLLATE utf8mb4_unicode_520_ci,
  `page_referrer` text COLLATE utf8mb4_unicode_520_ci,
  `page_urlscheme` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `page_urlhost` text COLLATE utf8mb4_unicode_520_ci,
  `page_urlport` int DEFAULT NULL,
  `page_urlpath` text COLLATE utf8mb4_unicode_520_ci,
  `page_urlquery` text COLLATE utf8mb4_unicode_520_ci,
  `page_urlfragment` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `refr_urlscheme` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `refr_urlhost` text COLLATE utf8mb4_unicode_520_ci,
  `refr_urlport` int DEFAULT NULL,
  `refr_urlpath` text COLLATE utf8mb4_unicode_520_ci,
  `refr_urlquery` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `refr_urlfragment` text COLLATE utf8mb4_unicode_520_ci,
  `refr_medium` varchar(25) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `refr_source` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `refr_term` text COLLATE utf8mb4_unicode_520_ci,
  `mkt_medium` text COLLATE utf8mb4_unicode_520_ci,
  `mkt_source` text COLLATE utf8mb4_unicode_520_ci,
  `mkt_term` text COLLATE utf8mb4_unicode_520_ci,
  `mkt_content` text COLLATE utf8mb4_unicode_520_ci,
  `mkt_campaign` text COLLATE utf8mb4_unicode_520_ci,
  `contexts` text COLLATE utf8mb4_unicode_520_ci,
  `se_category` text COLLATE utf8mb4_unicode_520_ci,
  `se_action` text COLLATE utf8mb4_unicode_520_ci,
  `se_label` text COLLATE utf8mb4_unicode_520_ci,
  `se_property` text COLLATE utf8mb4_unicode_520_ci,
  `se_value` double DEFAULT NULL,
  `unstruct_event` text COLLATE utf8mb4_unicode_520_ci,
  `tr_orderid` text COLLATE utf8mb4_unicode_520_ci,
  `tr_affiliation` text COLLATE utf8mb4_unicode_520_ci,
  `tr_total` decimal(18,2) DEFAULT NULL,
  `tr_tax` decimal(18,2) DEFAULT NULL,
  `tr_shipping` decimal(18,2) DEFAULT NULL,
  `tr_city` text COLLATE utf8mb4_unicode_520_ci,
  `tr_state` text COLLATE utf8mb4_unicode_520_ci,
  `tr_country` text COLLATE utf8mb4_unicode_520_ci,
  `ti_orderid` text COLLATE utf8mb4_unicode_520_ci,
  `ti_sku` text COLLATE utf8mb4_unicode_520_ci,
  `ti_name` text COLLATE utf8mb4_unicode_520_ci,
  `ti_category` text COLLATE utf8mb4_unicode_520_ci,
  `ti_price` decimal(18,2) DEFAULT NULL,
  `ti_quantity` int DEFAULT NULL,
  `pp_xoffset_min` int DEFAULT NULL,
  `pp_xoffset_max` int DEFAULT NULL,
  `pp_yoffset_min` int DEFAULT NULL,
  `pp_yoffset_max` int DEFAULT NULL,
  `useragent` text COLLATE utf8mb4_unicode_520_ci,
  `br_name` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `br_family` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `br_version` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `br_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `br_renderengine` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `br_lang` text COLLATE utf8mb4_unicode_520_ci,
  `br_features_pdf` tinyint(1) DEFAULT NULL,
  `br_features_flash` tinyint(1) DEFAULT NULL,
  `br_features_java` tinyint(1) DEFAULT NULL,
  `br_features_director` tinyint(1) DEFAULT NULL,
  `br_features_quicktime` tinyint(1) DEFAULT NULL,
  `br_features_realplayer` tinyint(1) DEFAULT NULL,
  `br_features_windowsmedia` tinyint(1) DEFAULT NULL,
  `br_features_gears` tinyint(1) DEFAULT NULL,
  `br_features_silverlight` tinyint(1) DEFAULT NULL,
  `br_cookies` tinyint(1) DEFAULT NULL,
  `br_colordepth` text COLLATE utf8mb4_unicode_520_ci,
  `br_viewwidth` int DEFAULT NULL,
  `br_viewheight` int DEFAULT NULL,
  `os_name` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `os_family` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `os_manufacturer` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `os_timezone` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `dvce_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `dvce_ismobile` tinyint(1) DEFAULT NULL,
  `dvce_screenwidth` int DEFAULT NULL,
  `dvce_screenheight` int DEFAULT NULL,
  `doc_charset` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `doc_width` int DEFAULT NULL,
  `doc_height` int DEFAULT NULL,
  `geo_timezone` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `mkt_clickid` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `mkt_network` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `etl_tags` text COLLATE utf8mb4_unicode_520_ci,
  `dvce_sent_tstamp` bigint DEFAULT NULL,
  `domain_sessionid` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of log_event
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mail_queue
-- ----------------------------
DROP TABLE IF EXISTS `mail_queue`;
CREATE TABLE `mail_queue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `from` text COLLATE utf8mb4_unicode_520_ci,
  `to` text COLLATE utf8mb4_unicode_520_ci,
  `cc` text COLLATE utf8mb4_unicode_520_ci,
  `bcc` text COLLATE utf8mb4_unicode_520_ci,
  `subject` text COLLATE utf8mb4_unicode_520_ci,
  `html_body` text COLLATE utf8mb4_unicode_520_ci,
  `text_body` text COLLATE utf8mb4_unicode_520_ci,
  `reply_to` text COLLATE utf8mb4_unicode_520_ci,
  `charset` text COLLATE utf8mb4_unicode_520_ci,
  `attachments` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  `attempts` int DEFAULT NULL,
  `last_attempt_time` datetime DEFAULT NULL,
  `sent_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of mail_queue
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for migration
-- ----------------------------
DROP TABLE IF EXISTS `migration`;
CREATE TABLE `migration` (
  `version` varchar(180) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `apply_time` int DEFAULT NULL,
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of migration
-- ----------------------------
BEGIN;
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m000000_000000_base', 1725987817);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m150214_044830_init_user', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m150410_183765_init_setting', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m150412_184646_init_theme', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m150415_183345_init_form', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m150420_183546_init_stats', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m150420_183547_init_template', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m150420_183548_init_mailqueue', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m150420_183550_init_addon', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m160104_150526_add_slug_to_form', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m160110_151514_add_password_novalidate_to_form', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m160118_171459_upgrade_user_module', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m160630_181205_upgrade_to_136', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m160813_213103_upgrade_to_137', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m160813_213105_upgrade_to_139', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m190624_153537_upgrade_to_170', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m190811_215815_upgrade_to_172', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m191202_174827_upgrade_to_191', 1725987826);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m191218_212749_upgrade_to_1_10', 1725987827);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m200618_202154_upgrade_to_1_12', 1725987827);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m210510_232206_upgraate_to_1_14', 1725987827);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m210906_234721_upgrade_to_1_15', 1725987827);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m210921_231209_upgrade_to_1_16', 1725987827);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m211201_164734_upgrade_to_1_17', 1725987827);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m240503_162850_upgrade_to_2_1', 1725987827);
INSERT INTO `migration` (`version`, `apply_time`) VALUES ('m240713_175431_upgrade_to_2_2', 1725987827);
COMMIT;

-- ----------------------------
-- Table structure for profile
-- ----------------------------
DROP TABLE IF EXISTS `profile`;
CREATE TABLE `profile` (
  `user_id` int NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `timezone` text COLLATE utf8mb4_unicode_520_ci,
  `language` text COLLATE utf8mb4_unicode_520_ci,
  `public_email` text COLLATE utf8mb4_unicode_520_ci,
  `gravatar_email` text COLLATE utf8mb4_unicode_520_ci,
  `gravatar_id` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `location` text COLLATE utf8mb4_unicode_520_ci,
  `website` text COLLATE utf8mb4_unicode_520_ci,
  `bio` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of profile
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for setting
-- ----------------------------
DROP TABLE IF EXISTS `setting`;
CREATE TABLE `setting` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_category_key` (`category`,`key`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of setting
-- ----------------------------
BEGIN;
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (1, 'string', 'app', 'name', 'Easy Forms', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (2, 'string', 'app', 'description', '<p>Welcome to <span style=\"color: #c9d2db;\"> the easiest way </span> to build, design and manage <span style=\"color: #e8ebef; font-weight: bold;\"> your online forms</span>.</p>', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (3, 'string', 'app', 'adminEmail', 'admin@example.com', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (4, 'string', 'app', 'supportEmail', 'support@example.com', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (5, 'string', 'app', 'noreplyEmail', 'no-reply@example.com', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (6, 'string', 'app', 'reCaptchaVersion', '2', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (7, 'string', 'app', 'reCaptchaSecret', 'your_secret', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (8, 'string', 'app', 'reCaptchaSiteKey', 'your_site_key', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (9, 'string', 'smtp', 'host', 'localhost', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (10, 'string', 'smtp', 'port', '25', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (11, 'string', 'smtp', 'encryption', 'none', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (12, 'string', 'smtp', 'username', 'Username', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (13, 'string', 'smtp', 'password', 'Password', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (14, 'integer', 'app', 'anyoneCanRegister', '0', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (15, 'integer', 'app', 'loginWithoutPassword', '0', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (16, 'integer', 'app', 'useCaptcha', '0', 1, 1725987826, 1725987826);
INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES (17, 'integer', 'app', 'defaultUserRole', '2', 1, 1725987826, 1725987826);
COMMIT;

-- ----------------------------
-- Table structure for social_account
-- ----------------------------
DROP TABLE IF EXISTS `social_account`;
CREATE TABLE `social_account` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `provider` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `client_id` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `code` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email` text COLLATE utf8mb4_unicode_520_ci,
  `username` text COLLATE utf8mb4_unicode_520_ci,
  `data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of social_account
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for stats_performance
-- ----------------------------
DROP TABLE IF EXISTS `stats_performance`;
CREATE TABLE `stats_performance` (
  `day` date NOT NULL,
  `app_id` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `users` int DEFAULT NULL,
  `fills` int DEFAULT NULL,
  `conversions` int DEFAULT NULL,
  `conversionTime` bigint unsigned DEFAULT NULL,
  UNIQUE KEY `stats_performance_day_app_id` (`day`,`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of stats_performance
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for stats_submissions
-- ----------------------------
DROP TABLE IF EXISTS `stats_submissions`;
CREATE TABLE `stats_submissions` (
  `app_id` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `collector_tstamp` int NOT NULL,
  `domain_sessionidx` smallint DEFAULT NULL,
  `geo_country` text COLLATE utf8mb4_unicode_520_ci,
  `geo_city` varchar(75) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `refr_urlhost` text COLLATE utf8mb4_unicode_520_ci,
  `refr_medium` varchar(25) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `br_family` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `os_family` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `dvce_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `dvce_ismobile` tinyint(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of stats_submissions
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for template
-- ----------------------------
DROP TABLE IF EXISTS `template`;
CREATE TABLE `template` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_id` int DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci,
  `builder` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `html` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `version` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `promoted` tinyint(1) DEFAULT '0',
  `shared` int DEFAULT '0',
  `slug` text COLLATE utf8mb4_unicode_520_ci,
  `created_by` int NOT NULL,
  `updated_by` int NOT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ----------------------------
-- Records of template
-- ----------------------------
BEGIN;
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `version`, `promoted`, `shared`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES (1, 1, 'Basic Contact Form', 'Contact information is important for business owners, professionals, and other organizations. This form allows you to collect name, email addresses and other information so that you can reach personal or business contacts in the future.', '{\"settings\":{\"name\":\"Contact Us\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[]},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Contact Us\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":true,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":false,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"type\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"Let us know your questions, suggestions and concerns by filling out the contact form below.\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"email\",\"title\":\"email.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"email_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Email\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"checkdns\":{\"label\":\"component.checkDNS\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"checkdns\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Message\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"selected\":true,\"label\":\"Submit\"},{\"value\":\"reset\",\"selected\":false,\"label\":\"Reset\"},{\"value\":\"image\",\"selected\":false,\"label\":\"Image\"},{\"value\":\"button\",\"selected\":false,\"label\":\"Button\"}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"styles\":[{\"name\":\"global\",\"selector\":\"#canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form\",\"selector\":\"#canvas form\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-group\",\"selector\":\"#canvas form .form-group\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control\",\"selector\":\"#canvas form .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control-focus\",\"selector\":\"#canvas form .form-control:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary\",\"selector\":\"#canvas form .btn.btn-primary\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary-hover\",\"selector\":\"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default\",\"selector\":\"#canvas form .btn.btn-default\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default-hover\",\"selector\":\"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning\",\"selector\":\"#canvas form .btn.btn-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning-hover\",\"selector\":\"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger-hover\",\"selector\":\"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info-hover\",\"selector\":\"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"control-label\",\"selector\":\"#canvas form .control-label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"placeholder\",\"selector\":\"#canvas form ::placeholder\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"heading\",\"selector\":\"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"paragraph\",\"selector\":\"#canvas form p\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"help-block\",\"selector\":\"#canvas form .help-block\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link\",\"selector\":\"#canvas form a\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link-hover\",\"selector\":\"#canvas form a:hover\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step\",\"selector\":\"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-stage\",\"selector\":\"#canvas form .steps .step .stage\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-connection\",\"selector\":\"#canvas form .steps .step:after, #canvas form .steps .step:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current\",\"selector\":\"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success\",\"selector\":\"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-title\",\"selector\":\"#canvas form .steps .step .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current-title\",\"selector\":\"#canvas form .steps .step.current .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success-title\",\"selector\":\"#canvas form .steps .step.success .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert\",\"selector\":\".alert\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-success\",\"selector\":\".alert-success\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-danger\",\"selector\":\".alert-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-info\",\"selector\":\".alert-info\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-warning\",\"selector\":\".alert-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-field\",\"selector\":\".has-error .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-text\",\"selector\":\".has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox, .has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label, .has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-symbol-asterisk\",\"selector\":\".required .control-label:after, .required-control .control-label:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"recaptcha\",\"selector\":\"#recaptcha, .g-recaptcha\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-pad\",\"selector\":\".signature-pad\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-canvas\",\"selector\":\".signature-pad canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-input\",\"selector\":\"input[type=checkbox]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-inline\",\"selector\":\".checkbox-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-input\",\"selector\":\"input[type=radio]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-inline\",\"selector\":\".radio-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-before\",\"selector\":\".custom-control .checkbox label::before, .custom-control .inline-control-checkbox label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-after\",\"selector\":\".custom-control .checkbox label::after, .custom-control .inline-control-checkbox label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-before\",\"selector\":\".custom-control .checkbox input:checked+label::before, .custom-control .inline-control-checkbox input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-after\",\"selector\":\".custom-control .checkbox input:checked+label::after, .custom-control .inline-control-checkbox input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-before\",\"selector\":\".custom-control .radio label::before, .custom-control .inline-control-radio label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-after\",\"selector\":\".custom-control .radio label::after, .custom-control .inline-control-radio label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-before\",\"selector\":\".custom-control .radio input:checked+label::before, .custom-control .inline-control-radio input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-after\",\"selector\":\".custom-control .radio input:checked+label::after, .custom-control .inline-control-radio input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev\",\"selector\":\".btn.prev\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev-hover\",\"selector\":\"#canvas form .btn.prev:hover, #canvas form .btn.prev:active, #canvas form .btn.prev:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next\",\"selector\":\".btn.next\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next-hover\",\"selector\":\"#canvas form .btn.next:hover, #canvas form .btn.next:active, #canvas form .btn.next:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar-container\",\"selector\":\".progress\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar\",\"selector\":\".progress-bar\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"table\",\"selector\":\".table\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"well\",\"selector\":\".well\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}}],\"height\":417}', '&lt;form id=&quot;form-app&quot;&gt;\n&lt;fieldset class=&quot;row&quot;&gt;\n\n&lt;!-- Heading --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;h1 &gt;Contact Us&lt;/h1&gt;\n&lt;/div&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;p&gt;Let us know your questions, suggestions and concerns by filling out the contact form below.&lt;/p&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;text_1&quot;&gt;Name&lt;/label&gt;\n        &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Email --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group required-control&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;email_1&quot;&gt;Email&lt;/label&gt;\n        &lt;input type=&quot;email&quot; id=&quot;email_1&quot; name=&quot;email_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group required-control&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;textarea_1&quot;&gt;Message&lt;/label&gt;\n        &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;&lt;/textarea&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n     &lt;div class=&quot;form-action&quot;&gt;\n        &lt;button type=&quot;submit&quot; id=&quot;button_1&quot; name=&quot;button_1&quot; class=&quot;btn btn-primary&quot;&gt;Submit&lt;/button&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n&lt;/fieldset&gt;\n&lt;/form&gt;', NULL, 1, 0, 'basic-contact-form', 1, 1, 1725986926, 1725987826);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `version`, `promoted`, `shared`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES (2, 2, 'Customer Satisfaction Survey', 'You don\'t need an expensive marketing research team to gather detailed information about your customers. Instead, use this survey for a quick and easy way to get invaluable feedback from customers on the quality of your product or service.', '{\"settings\":{\"name\":\"Customer Satisfaction Survey\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[]},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Customer Satisfaction Survey\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":true,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":false,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"type\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"Please take a few moments to complete this satisfaction survey.\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Overall, how satisfied were you with the product \\/ service?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Very Satisfied\",\"Satisfied\",\"Neutral\",\"Unsatisfied\",\"Very Unsatisfied\",\"N\\/A\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-check\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Would you recommend our product \\/ service to colleagues or contacts within your industry?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Definitely\",\"Probably\",\"Not Sure\",\"Probably Not\",\"Definitely Not\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-check\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_3\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Would you use our product \\/ service in the future?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Less than a month\",\"1-6 months\",\"1-3 years\",\"Over 3 Years\",\"Never used\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-check\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_4\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"How often do you use product \\/ service?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Once a week\",\"2 to 3 times a month\",\"Once a month\",\"Less than once a month\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-check\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_5\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"What aspect of the product \\/ service were you most satisfied by?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Quality\",\"Price\",\"Purchase Experience\",\"Installation or First Use Experience\",\"Usage Experience\",\"Customer Service\",\"Repeat Purchase Experience\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-check\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"What do you like about the product \\/ service?\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"What do you dislike about the product \\/ service?\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_6\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Thinking of similar products \\/ services offered by other companies, how would you compare the product \\/ service offered by our company?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Much Better\",\"Somewhat Better\",\"About the Same\",\"Somewhat Worse\",\"Much Worse\",\"Don\\u0027t Know\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-check\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"selected\":true,\"label\":\"Submit\"},{\"value\":\"reset\",\"selected\":false,\"label\":\"Reset\"},{\"value\":\"image\",\"selected\":false,\"label\":\"Image\"},{\"value\":\"button\",\"selected\":false,\"label\":\"Button\"}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"styles\":[{\"name\":\"global\",\"selector\":\"#canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form\",\"selector\":\"#canvas form\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-group\",\"selector\":\"#canvas form .form-group\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control\",\"selector\":\"#canvas form .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control-focus\",\"selector\":\"#canvas form .form-control:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary\",\"selector\":\"#canvas form .btn.btn-primary\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary-hover\",\"selector\":\"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default\",\"selector\":\"#canvas form .btn.btn-default\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default-hover\",\"selector\":\"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning\",\"selector\":\"#canvas form .btn.btn-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning-hover\",\"selector\":\"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger-hover\",\"selector\":\"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info-hover\",\"selector\":\"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"control-label\",\"selector\":\"#canvas form .control-label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"placeholder\",\"selector\":\"#canvas form ::placeholder\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"heading\",\"selector\":\"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"paragraph\",\"selector\":\"#canvas form p\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"help-block\",\"selector\":\"#canvas form .help-block\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link\",\"selector\":\"#canvas form a\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link-hover\",\"selector\":\"#canvas form a:hover\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step\",\"selector\":\"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-stage\",\"selector\":\"#canvas form .steps .step .stage\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-connection\",\"selector\":\"#canvas form .steps .step:after, #canvas form .steps .step:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current\",\"selector\":\"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success\",\"selector\":\"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-title\",\"selector\":\"#canvas form .steps .step .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current-title\",\"selector\":\"#canvas form .steps .step.current .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success-title\",\"selector\":\"#canvas form .steps .step.success .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert\",\"selector\":\".alert\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-success\",\"selector\":\".alert-success\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-danger\",\"selector\":\".alert-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-info\",\"selector\":\".alert-info\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-warning\",\"selector\":\".alert-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-field\",\"selector\":\".has-error .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-text\",\"selector\":\".has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox, .has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label, .has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-symbol-asterisk\",\"selector\":\".required .control-label:after, .required-control .control-label:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"recaptcha\",\"selector\":\"#recaptcha, .g-recaptcha\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-pad\",\"selector\":\".signature-pad\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-canvas\",\"selector\":\".signature-pad canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-input\",\"selector\":\"input[type=checkbox]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-inline\",\"selector\":\".checkbox-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-input\",\"selector\":\"input[type=radio]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-inline\",\"selector\":\".radio-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-before\",\"selector\":\".custom-control .checkbox label::before, .custom-control .inline-control-checkbox label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-after\",\"selector\":\".custom-control .checkbox label::after, .custom-control .inline-control-checkbox label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-before\",\"selector\":\".custom-control .checkbox input:checked+label::before, .custom-control .inline-control-checkbox input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-after\",\"selector\":\".custom-control .checkbox input:checked+label::after, .custom-control .inline-control-checkbox input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-before\",\"selector\":\".custom-control .radio label::before, .custom-control .inline-control-radio label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-after\",\"selector\":\".custom-control .radio label::after, .custom-control .inline-control-radio label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-before\",\"selector\":\".custom-control .radio input:checked+label::before, .custom-control .inline-control-radio input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-after\",\"selector\":\".custom-control .radio input:checked+label::after, .custom-control .inline-control-radio input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev\",\"selector\":\".btn.prev\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev-hover\",\"selector\":\"#canvas form .btn.prev:hover, #canvas form .btn.prev:active, #canvas form .btn.prev:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next\",\"selector\":\".btn.next\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next-hover\",\"selector\":\"#canvas form .btn.next:hover, #canvas form .btn.next:active, #canvas form .btn.next:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar-container\",\"selector\":\".progress\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar\",\"selector\":\".progress-bar\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"table\",\"selector\":\".table\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"well\",\"selector\":\".well\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}}],\"height\":1532}', '&lt;form id=&quot;form-app&quot;&gt;\n&lt;fieldset class=&quot;row&quot;&gt;\n\n&lt;!-- Heading --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;h1 &gt;Customer Satisfaction Survey&lt;/h1&gt;\n&lt;/div&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;p&gt;Please take a few moments to complete this satisfaction survey.&lt;/p&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt; \n        &lt;label  class=&quot;form-label&quot; for=&quot;radio_1&quot;&gt;Overall, how satisfied were you with the product / service?&lt;/label&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; class=&quot;form-check-input&quot; value=&quot;Very Satisfied&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_0&quot;&gt;\n                Very Satisfied &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; class=&quot;form-check-input&quot; value=&quot;Satisfied&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_1&quot;&gt;\n                Satisfied &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; class=&quot;form-check-input&quot; value=&quot;Neutral&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_2&quot;&gt;\n                Neutral &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_3&quot; class=&quot;form-check-input&quot; value=&quot;Unsatisfied&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_3&quot;&gt;\n                Unsatisfied &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_4&quot; class=&quot;form-check-input&quot; value=&quot;Very Unsatisfied&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_4&quot;&gt;\n                Very Unsatisfied &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_5&quot; class=&quot;form-check-input&quot; value=&quot;N/A&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_5&quot;&gt;\n                N/A &lt;/label&gt;\n        &lt;/div&gt; \n        &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;\n        \n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt; \n        &lt;label  class=&quot;form-label&quot; for=&quot;radio_2&quot;&gt;Would you recommend our product / service to colleagues or contacts within your industry?&lt;/label&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_0&quot; class=&quot;form-check-input&quot; value=&quot;Definitely&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_2_0&quot;&gt;\n                Definitely &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_1&quot; class=&quot;form-check-input&quot; value=&quot;Probably&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_2_1&quot;&gt;\n                Probably &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_2&quot; class=&quot;form-check-input&quot; value=&quot;Not Sure&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_2_2&quot;&gt;\n                Not Sure &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_3&quot; class=&quot;form-check-input&quot; value=&quot;Probably Not&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_2_3&quot;&gt;\n                Probably Not &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_4&quot; class=&quot;form-check-input&quot; value=&quot;Definitely Not&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_2_4&quot;&gt;\n                Definitely Not &lt;/label&gt;\n        &lt;/div&gt; \n        &lt;span id=&quot;radio_2&quot;&gt;&lt;/span&gt;\n        \n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt; \n        &lt;label  class=&quot;form-label&quot; for=&quot;radio_3&quot;&gt;Would you use our product / service in the future?&lt;/label&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_0&quot; class=&quot;form-check-input&quot; value=&quot;Less than a month&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_3_0&quot;&gt;\n                Less than a month &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_1&quot; class=&quot;form-check-input&quot; value=&quot;1-6 months&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_3_1&quot;&gt;\n                1-6 months &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_2&quot; class=&quot;form-check-input&quot; value=&quot;1-3 years&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_3_2&quot;&gt;\n                1-3 years &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_3&quot; class=&quot;form-check-input&quot; value=&quot;Over 3 Years&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_3_3&quot;&gt;\n                Over 3 Years &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_4&quot; class=&quot;form-check-input&quot; value=&quot;Never used&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_3_4&quot;&gt;\n                Never used &lt;/label&gt;\n        &lt;/div&gt; \n        &lt;span id=&quot;radio_3&quot;&gt;&lt;/span&gt;\n        \n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt; \n        &lt;label  class=&quot;form-label&quot; for=&quot;radio_4&quot;&gt;How often do you use product / service?&lt;/label&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_0&quot; class=&quot;form-check-input&quot; value=&quot;Once a week&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_4_0&quot;&gt;\n                Once a week &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_1&quot; class=&quot;form-check-input&quot; value=&quot;2 to 3 times a month&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_4_1&quot;&gt;\n                2 to 3 times a month &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_2&quot; class=&quot;form-check-input&quot; value=&quot;Once a month&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_4_2&quot;&gt;\n                Once a month &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_3&quot; class=&quot;form-check-input&quot; value=&quot;Less than once a month&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_4_3&quot;&gt;\n                Less than once a month &lt;/label&gt;\n        &lt;/div&gt; \n        &lt;span id=&quot;radio_4&quot;&gt;&lt;/span&gt;\n        \n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt; \n        &lt;label  class=&quot;form-label&quot; for=&quot;radio_5&quot;&gt;What aspect of the product / service were you most satisfied by?&lt;/label&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_0&quot; class=&quot;form-check-input&quot; value=&quot;Quality&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_0&quot;&gt;\n                Quality &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_1&quot; class=&quot;form-check-input&quot; value=&quot;Price&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_1&quot;&gt;\n                Price &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_2&quot; class=&quot;form-check-input&quot; value=&quot;Purchase Experience&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_2&quot;&gt;\n                Purchase Experience &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_3&quot; class=&quot;form-check-input&quot; value=&quot;Installation or First Use Experience&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_3&quot;&gt;\n                Installation or First Use Experience &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_4&quot; class=&quot;form-check-input&quot; value=&quot;Usage Experience&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_4&quot;&gt;\n                Usage Experience &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_5&quot; class=&quot;form-check-input&quot; value=&quot;Customer Service&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_5&quot;&gt;\n                Customer Service &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_6&quot; class=&quot;form-check-input&quot; value=&quot;Repeat Purchase Experience&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_6&quot;&gt;\n                Repeat Purchase Experience &lt;/label&gt;\n        &lt;/div&gt; \n        &lt;span id=&quot;radio_5&quot;&gt;&lt;/span&gt;\n        \n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;textarea_1&quot;&gt;What do you like about the product / service?&lt;/label&gt;\n        &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;textarea_2&quot;&gt;What do you dislike about the product / service?&lt;/label&gt;\n        &lt;textarea id=&quot;textarea_2&quot; name=&quot;textarea_2&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt; \n        &lt;label  class=&quot;form-label&quot; for=&quot;radio_6&quot;&gt;Thinking of similar products / services offered by other companies, how would you compare the product / service offered by our company?&lt;/label&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_0&quot; class=&quot;form-check-input&quot; value=&quot;Much Better&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_0&quot;&gt;\n                Much Better &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_1&quot; class=&quot;form-check-input&quot; value=&quot;Somewhat Better&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_1&quot;&gt;\n                Somewhat Better &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_2&quot; class=&quot;form-check-input&quot; value=&quot;About the Same&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_2&quot;&gt;\n                About the Same &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_3&quot; class=&quot;form-check-input&quot; value=&quot;Somewhat Worse&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_3&quot;&gt;\n                Somewhat Worse &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_4&quot; class=&quot;form-check-input&quot; value=&quot;Much Worse&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_4&quot;&gt;\n                Much Worse &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_5&quot; class=&quot;form-check-input&quot; value=&quot;Don&amp;#x27;t Know&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_5&quot;&gt;\n                Don&#039;t Know &lt;/label&gt;\n        &lt;/div&gt; \n        &lt;span id=&quot;radio_6&quot;&gt;&lt;/span&gt;\n        \n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n     &lt;div class=&quot;form-action&quot;&gt;\n        &lt;button type=&quot;submit&quot; id=&quot;button_1&quot; name=&quot;button_1&quot; class=&quot;btn btn-primary&quot;&gt;Submit&lt;/button&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n&lt;/fieldset&gt;\n&lt;/form&gt;', NULL, 1, 0, 'customer-satisfaction-survey', 1, 1, 1725986926, 1725986926);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `version`, `promoted`, `shared`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES (3, 1, 'Job Application Form', 'Easy way to apply online. Gather information and upload resume using the form.', '{\"settings\":{\"name\":\"Product Manager\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[]},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Product Manager\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":true,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":false,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"type\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_1\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"\\u003Cstrong\\u003EWill you be our next Product Manager?\\u003C\\/strong\\u003E\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"snippet\",\"title\":\"snippet.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"snippet_1\",\"name\":\"id\"},\"snippet\":{\"label\":\"component.htmlCode\",\"type\":\"textarea\",\"value\":\"\\u003Cdiv style=\\u0022border: 1px solid #DDD; padding: 10px; overflow-y: scroll; height: 200px; margin-bottom: 20px;\\u0022\\u003E\\n\\u003Cp\\u003E\\u003Cstrong\\u003EAre you...\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n\\u003Cul\\u003E\\n\\u003Cli\\u003EFascinated by software products and how they can impact the lives of their users?\\u003C\\/li\\u003E\\n\\u003Cli\\u003ESomeone who enjoys collaborating with customers, developers and marketers to develop a roadmap for a product?\\u003C\\/li\\u003E\\n\\u003Cli\\u003EA person that enjoys being a vital part of an organization?\\u003C\\/li\\u003E\\n\\u003Cli\\u003EA believer that great software can provide significant savings of time and money?\\u003C\\/li\\u003E\\n\\u003C\\/ul\\u003E\\n\\u003Cp\\u003EIf so, you should consider applying to become our next Product Manager.\\u003C\\/p\\u003E\\n\\u003Cp\\u003EWe are looking for a high energy and fun person to add to our team.\\u003C\\/p\\u003E\\n\\u003Cp\\u003EThey will have the opportunity to significantly direct and impact the development path of our web application and the future of our product.\\u003C\\/p\\u003E\\n\\u003Cp\\u003E\\u003Cstrong\\u003EResponsibilities:\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n\\u003Cul\\u003E\\n\\u003Cli\\u003EDefining new improvements for our web application, gathering requirements \\u0026amp; documenting designs\\u003C\\/li\\u003E\\n\\u003Cli\\u003ECollect and interpret customer feedback and needs but realize the customer might not always know what they need\\u003C\\/li\\u003E\\n\\u003Cli\\u003EUtilize a healthy amount of intuition but balance that with the appropriate amount of \\u0027data\\u0027 to back your decisions\\u003C\\/li\\u003E\\n\\u003Cli\\u003EAbility to prioritize\\u003C\\/li\\u003E\\n\\u003Cli\\u003EManage usability testing of new features to understand the \\u0022how\\u0022 and \\u0022why\\u0022 for people who use the software\\u003C\\/li\\u003E\\n\\u003Cli\\u003EProject management, seeing all projects from start to finish, new software every week\\u003C\\/li\\u003E\\n\\u003Cli\\u003ECollaborate with Marketing to define the strategies and define use cases\\u003C\\/li\\u003E\\n\\u003Cli\\u003EWork with the Customer Experience Team to analyze customer feedback and feature requests\\u003C\\/li\\u003E\\n\\u003Cli\\u003EInsure the end product is meeting the goals set in the beginning\\u003C\\/li\\u003E\\n\\u003C\\/ul\\u003E\\n\\u003Cp\\u003E\\u003Cstrong\\u003ESkills:\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n\\u003Cul\\u003E\\n\\u003Cli\\u003EKnowledge of Web Applications, SaaS companies and more than 4 years of experience guiding product development\\u003C\\/li\\u003E\\n\\u003Cli\\u003EA background or passion for user experience and design\\u003C\\/li\\u003E\\n\\u003Cli\\u003ETechnical understanding of the limitations and possibilities within the Web Applications space\\u003C\\/li\\u003E\\n\\u003Cli\\u003EHighly organized with demonstrated effective verbal and written communication skills\\u003C\\/li\\u003E\\n\\u003Cli\\u003EAbility to act as a liaison between departments and maintain lines of communication\\u003C\\/li\\u003E\\n\\u003Cli\\u003EGoal-oriented but able to make changes and pivots when necessary\\u003C\\/li\\u003E\\n\\u003C\\/ul\\u003E\\n\\u003Cp\\u003E*we are an Indianapolis-based company but accept applications for remote team members\\u003C\\/p\\u003E\\n\\u003C\\/div\\u003E\",\"name\":\"snippet\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_2\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Last Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"email\",\"title\":\"email.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"email_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Email\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"checkdns\":{\"label\":\"component.checkDNS\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"checkdns\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_3\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Address\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"How did you find out about this position?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Current Employee\",\"Career Fair\",\"Newspaper Ad\",\"Radio\\/TV Ad\",\"Search Engine\",\"Other\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-check\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_4\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"If other, please specify\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"file\",\"title\":\"file.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"file_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Upload your resume\",\"name\":\"label\"},\"accept\":{\"label\":\"component.accept\",\"type\":\"input\",\"value\":\".pdf, .docx, .doc\",\"name\":\"accept\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minFiles\":{\"label\":\"component.minFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minFiles\"},\"maxFiles\":{\"label\":\"component.maxFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxFiles\"},\"minSize\":{\"label\":\"component.minSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minSize\"},\"maxSize\":{\"label\":\"component.maxSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"file\",\"title\":\"file.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"file_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Upload a cover letter\",\"name\":\"label\"},\"accept\":{\"label\":\"component.accept\",\"type\":\"input\",\"value\":\".gif, .jpg, .png\",\"name\":\"accept\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minFiles\":{\"label\":\"component.minFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minFiles\"},\"maxFiles\":{\"label\":\"component.maxFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxFiles\"},\"minSize\":{\"label\":\"component.minSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minSize\"},\"maxSize\":{\"label\":\"component.maxSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Additional info\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"selected\":true,\"label\":\"Submit\"},{\"value\":\"reset\",\"selected\":false,\"label\":\"Reset\"},{\"value\":\"image\",\"selected\":false,\"label\":\"Image\"},{\"value\":\"button\",\"selected\":false,\"label\":\"Button\"}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"styles\":[{\"name\":\"global\",\"selector\":\"#canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form\",\"selector\":\"#canvas form\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-group\",\"selector\":\"#canvas form .form-group\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control\",\"selector\":\"#canvas form .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control-focus\",\"selector\":\"#canvas form .form-control:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary\",\"selector\":\"#canvas form .btn.btn-primary\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary-hover\",\"selector\":\"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default\",\"selector\":\"#canvas form .btn.btn-default\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default-hover\",\"selector\":\"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning\",\"selector\":\"#canvas form .btn.btn-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning-hover\",\"selector\":\"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger-hover\",\"selector\":\"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info-hover\",\"selector\":\"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"control-label\",\"selector\":\"#canvas form .control-label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"placeholder\",\"selector\":\"#canvas form ::placeholder\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"heading\",\"selector\":\"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"paragraph\",\"selector\":\"#canvas form p\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"help-block\",\"selector\":\"#canvas form .help-block\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link\",\"selector\":\"#canvas form a\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link-hover\",\"selector\":\"#canvas form a:hover\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step\",\"selector\":\"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-stage\",\"selector\":\"#canvas form .steps .step .stage\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-connection\",\"selector\":\"#canvas form .steps .step:after, #canvas form .steps .step:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current\",\"selector\":\"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success\",\"selector\":\"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-title\",\"selector\":\"#canvas form .steps .step .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current-title\",\"selector\":\"#canvas form .steps .step.current .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success-title\",\"selector\":\"#canvas form .steps .step.success .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert\",\"selector\":\".alert\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-success\",\"selector\":\".alert-success\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-danger\",\"selector\":\".alert-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-info\",\"selector\":\".alert-info\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-warning\",\"selector\":\".alert-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-field\",\"selector\":\".has-error .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-text\",\"selector\":\".has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox, .has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label, .has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-symbol-asterisk\",\"selector\":\".required .control-label:after, .required-control .control-label:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"recaptcha\",\"selector\":\"#recaptcha, .g-recaptcha\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-pad\",\"selector\":\".signature-pad\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-canvas\",\"selector\":\".signature-pad canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-input\",\"selector\":\"input[type=checkbox]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-inline\",\"selector\":\".checkbox-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-input\",\"selector\":\"input[type=radio]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-inline\",\"selector\":\".radio-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-before\",\"selector\":\".custom-control .checkbox label::before, .custom-control .inline-control-checkbox label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-after\",\"selector\":\".custom-control .checkbox label::after, .custom-control .inline-control-checkbox label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-before\",\"selector\":\".custom-control .checkbox input:checked+label::before, .custom-control .inline-control-checkbox input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-after\",\"selector\":\".custom-control .checkbox input:checked+label::after, .custom-control .inline-control-checkbox input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-before\",\"selector\":\".custom-control .radio label::before, .custom-control .inline-control-radio label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-after\",\"selector\":\".custom-control .radio label::after, .custom-control .inline-control-radio label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-before\",\"selector\":\".custom-control .radio input:checked+label::before, .custom-control .inline-control-radio input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-after\",\"selector\":\".custom-control .radio input:checked+label::after, .custom-control .inline-control-radio input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev\",\"selector\":\".btn.prev\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev-hover\",\"selector\":\"#canvas form .btn.prev:hover, #canvas form .btn.prev:active, #canvas form .btn.prev:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next\",\"selector\":\".btn.next\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next-hover\",\"selector\":\"#canvas form .btn.next:hover, #canvas form .btn.next:active, #canvas form .btn.next:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar-container\",\"selector\":\".progress\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar\",\"selector\":\".progress-bar\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"table\",\"selector\":\".table\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"well\",\"selector\":\".well\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}}],\"height\":1230}', '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;\n&lt;fieldset class=&quot;row&quot;&gt;\n\n&lt;!-- Heading --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;h1 &gt;Product Manager&lt;/h1&gt;\n&lt;/div&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;p&gt;&lt;strong&gt;Will you be our next Product Manager?&lt;/strong&gt;&lt;/p&gt;\n&lt;/div&gt;\n\n&lt;!-- Snippet --&gt;\n&lt;div class=&quot;snippet col-12&quot;&gt;&lt;div style=&quot;border: 1px solid #DDD; padding: 10px; overflow-y: scroll; height: 200px; margin-bottom: 20px;&quot;&gt;\n&lt;p&gt;&lt;strong&gt;Are you...&lt;/strong&gt;&lt;/p&gt;\n&lt;ul&gt;\n&lt;li&gt;Fascinated by software products and how they can impact the lives of their users?&lt;/li&gt;\n&lt;li&gt;Someone who enjoys collaborating with customers, developers and marketers to develop a roadmap for a product?&lt;/li&gt;\n&lt;li&gt;A person that enjoys being a vital part of an organization?&lt;/li&gt;\n&lt;li&gt;A believer that great software can provide significant savings of time and money?&lt;/li&gt;\n&lt;/ul&gt;\n&lt;p&gt;If so, you should consider applying to become our next Product Manager.&lt;/p&gt;\n&lt;p&gt;We are looking for a high energy and fun person to add to our team.&lt;/p&gt;\n&lt;p&gt;They will have the opportunity to significantly direct and impact the development path of our web application and the future of our product.&lt;/p&gt;\n&lt;p&gt;&lt;strong&gt;Responsibilities:&lt;/strong&gt;&lt;/p&gt;\n&lt;ul&gt;\n&lt;li&gt;Defining new improvements for our web application, gathering requirements &amp;amp; documenting designs&lt;/li&gt;\n&lt;li&gt;Collect and interpret customer feedback and needs but realize the customer might not always know what they need&lt;/li&gt;\n&lt;li&gt;Utilize a healthy amount of intuition but balance that with the appropriate amount of &#039;data&#039; to back your decisions&lt;/li&gt;\n&lt;li&gt;Ability to prioritize&lt;/li&gt;\n&lt;li&gt;Manage usability testing of new features to understand the &quot;how&quot; and &quot;why&quot; for people who use the software&lt;/li&gt;\n&lt;li&gt;Project management, seeing all projects from start to finish, new software every week&lt;/li&gt;\n&lt;li&gt;Collaborate with Marketing to define the strategies and define use cases&lt;/li&gt;\n&lt;li&gt;Work with the Customer Experience Team to analyze customer feedback and feature requests&lt;/li&gt;\n&lt;li&gt;Insure the end product is meeting the goals set in the beginning&lt;/li&gt;\n&lt;/ul&gt;\n&lt;p&gt;&lt;strong&gt;Skills:&lt;/strong&gt;&lt;/p&gt;\n&lt;ul&gt;\n&lt;li&gt;Knowledge of Web Applications, SaaS companies and more than 4 years of experience guiding product development&lt;/li&gt;\n&lt;li&gt;A background or passion for user experience and design&lt;/li&gt;\n&lt;li&gt;Technical understanding of the limitations and possibilities within the Web Applications space&lt;/li&gt;\n&lt;li&gt;Highly organized with demonstrated effective verbal and written communication skills&lt;/li&gt;\n&lt;li&gt;Ability to act as a liaison between departments and maintain lines of communication&lt;/li&gt;\n&lt;li&gt;Goal-oriented but able to make changes and pivots when necessary&lt;/li&gt;\n&lt;/ul&gt;\n&lt;p&gt;*we are an Indianapolis-based company but accept applications for remote team members&lt;/p&gt;\n&lt;/div&gt;&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group required-control&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;text_1&quot;&gt;Name&lt;/label&gt;\n        &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group required-control&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;text_2&quot;&gt;Last Name&lt;/label&gt;\n        &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Email --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group required-control&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;email_1&quot;&gt;Email&lt;/label&gt;\n        &lt;input type=&quot;email&quot; id=&quot;email_1&quot; name=&quot;email_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group required-control&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;text_3&quot;&gt;Address&lt;/label&gt;\n        &lt;input type=&quot;text&quot; id=&quot;text_3&quot; name=&quot;text_3&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt; \n        &lt;label  class=&quot;form-label&quot; for=&quot;radio_1&quot;&gt;How did you find out about this position?&lt;/label&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; class=&quot;form-check-input&quot; value=&quot;Current Employee&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_0&quot;&gt;\n                Current Employee &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; class=&quot;form-check-input&quot; value=&quot;Career Fair&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_1&quot;&gt;\n                Career Fair &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; class=&quot;form-check-input&quot; value=&quot;Newspaper Ad&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_2&quot;&gt;\n                Newspaper Ad &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_3&quot; class=&quot;form-check-input&quot; value=&quot;Radio/TV Ad&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_3&quot;&gt;\n                Radio/TV Ad &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_4&quot; class=&quot;form-check-input&quot; value=&quot;Search Engine&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_4&quot;&gt;\n                Search Engine &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;form-check&quot;&gt;\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_5&quot; class=&quot;form-check-input&quot; value=&quot;Other&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_5&quot;&gt;\n                Other &lt;/label&gt;\n        &lt;/div&gt; \n        &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;\n        \n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;text_4&quot;&gt;If other, please specify&lt;/label&gt;\n        &lt;input type=&quot;text&quot; id=&quot;text_4&quot; name=&quot;text_4&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- File --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;file_1&quot;&gt;Upload your resume&lt;/label&gt;\n        &lt;input type=&quot;file&quot; id=&quot;file_1&quot; name=&quot;file_1[]&quot; data-alias=&quot;&quot; accept=&quot;.pdf, .docx, .doc&quot;&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n\n&lt;!-- File --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;file_2&quot;&gt;Upload a cover letter&lt;/label&gt;\n        &lt;input type=&quot;file&quot; id=&quot;file_2&quot; name=&quot;file_2[]&quot; data-alias=&quot;&quot; accept=&quot;.gif, .jpg, .png&quot;&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n    &lt;div class=&quot;form-group&quot;&gt;\n        &lt;label  class=&quot;form-label&quot; for=&quot;textarea_1&quot;&gt;Additional info&lt;/label&gt;\n        &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;col-12&quot;&gt;\n     &lt;div class=&quot;form-action&quot;&gt;\n        &lt;button type=&quot;submit&quot; id=&quot;button_1&quot; name=&quot;button_1&quot; class=&quot;btn btn-primary&quot;&gt;Submit&lt;/button&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n&lt;/fieldset&gt;\n&lt;/form&gt;', NULL, 1, 0, 'job-application-form', 1, 1, 1725986926, 1725986926);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `version`, `promoted`, `shared`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES (4, 7, 'Bug Tracker', 'Do you need to track bugs for an IT department or a group of developers? With this form, you can collect and track the information you need to quickly and effectively intake clients. ', '{\"settings\":{\"name\":\"Bug Tracker\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[]},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Bug Tracker\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":true,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":false,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"type\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"Report all bugs!\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Bug Title\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Issue Description\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Operating System\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"choice\",\"value\":[\"Windows XP\",\"Windows Vista\",\"Mac OS X\",\"Linux\",\"Other\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-select\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Browser\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"choice\",\"value\":[\"Internet Explorer\",\"Chrome\",\"Firefox\",\"Safari\",\"Opera\",\"Other\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-select\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_3\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Assign To\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"choice\",\"value\":[\"Team Member #1\",\"Team Member #2\",\"Team Member #3\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-select\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-9\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_4\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Priority\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"choice\",\"value\":[\"Low\",\"Medium\",\"High\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-select\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-3\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"file\",\"title\":\"file.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"file_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Upload a Screenshot\",\"name\":\"label\"},\"accept\":{\"label\":\"component.accept\",\"type\":\"input\",\"value\":\".gif, .jpg, .png\",\"name\":\"accept\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minFiles\":{\"label\":\"component.minFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minFiles\"},\"maxFiles\":{\"label\":\"component.maxFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxFiles\"},\"minSize\":{\"label\":\"component.minSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minSize\"},\"maxSize\":{\"label\":\"component.maxSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_5\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Status\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"choice\",\"value\":[\"New\",\"Acknowledged\",\"Confirmed\",\"Assigned\",\"Resolved\",\"Closed\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-select\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"selected\":true,\"label\":\"Submit\"},{\"value\":\"reset\",\"selected\":false,\"label\":\"Reset\"},{\"value\":\"image\",\"selected\":false,\"label\":\"Image\"},{\"value\":\"button\",\"selected\":false,\"label\":\"Button\"}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"form-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-12\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"styles\":[{\"name\":\"global\",\"selector\":\"#canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form\",\"selector\":\"#canvas form\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-group\",\"selector\":\"#canvas form .form-group\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control\",\"selector\":\"#canvas form .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control-focus\",\"selector\":\"#canvas form .form-control:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary\",\"selector\":\"#canvas form .btn.btn-primary\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary-hover\",\"selector\":\"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default\",\"selector\":\"#canvas form .btn.btn-default\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default-hover\",\"selector\":\"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning\",\"selector\":\"#canvas form .btn.btn-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning-hover\",\"selector\":\"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger-hover\",\"selector\":\"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info-hover\",\"selector\":\"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"control-label\",\"selector\":\"#canvas form .control-label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"placeholder\",\"selector\":\"#canvas form ::placeholder\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"heading\",\"selector\":\"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"paragraph\",\"selector\":\"#canvas form p\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"help-block\",\"selector\":\"#canvas form .help-block\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link\",\"selector\":\"#canvas form a\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\